<?php

/**
 * Plugin Name: Independent Analytics Pro
 * Plugin URI:        https://independentwp.com/
 * Description:       User-friendly website analytics built for WordPress
 * Version:           2.6.2
 * Update URI: https://api.freemius.com
 * Requires at least: 5.9
 * Tested up to:      6.5.2
 * Requires PHP:      7.3.33
 * Author:            Independent Analytics
 * Author URI:        https://independentwp.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       independent-analytics
 * Domain Path:       /languages
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( function_exists( 'IAWP_FS' ) ) {
    IAWP_FS()->set_basename( true, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    
    if ( !function_exists( 'IAWP_FS' ) ) {
        // Create a helper function for easy SDK access.
        function IAWP_FS()
        {
            global  $ia_fs ;
            
            if ( !isset( $ia_fs ) ) {
                // Activate multisite network integration.
                if ( !defined( 'WP_FS__PRODUCT_9944_MULTISITE' ) ) {
                    define( 'WP_FS__PRODUCT_9944_MULTISITE', true );
                }
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/freemius/start.php';
				
				class iawpFsNull {
					public function can_use_premium_code__premium_only() {
						return true;
					}
					public function add_filter( $tag, $function_to_add, $priority = 10, $accepted_args = 1 ) {
						add_filter( $tag, $function_to_add, $priority, $accepted_args );
					}
					public function add_action( $tag, $function_to_add, $priority = 10, $accepted_args = 1 ) {
						add_action( $tag, $function_to_add, $priority, $accepted_args );
					}
				}
				
                $ia_fs = new iawpFsNull();
            }
            
            return $ia_fs;
        }
        
        // Init Freemius.
        IAWP_FS();
        // Signal that SDK was initiated.
        do_action( 'ia_fs_loaded' );
    }
    
    // ... Your plugin's main file logic ...
    require_once rtrim( plugin_dir_path( __FILE__ ), DIRECTORY_SEPARATOR ) . '/iawp-bootstrap.php';
}
